#version 330

#include "transitionHelperGL.h"
#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;
uniform sampler2DRect maskTex;

uniform float transitionProgress=1.0;
uniform float transitionAlpha=1.0;
uniform float baseAlpha=1.0;
uniform int transitionState;
uniform int direction=0;
uniform float verticalDirectionFlip = 1.0;

in vec2 fsMaskTexture;
in vec2 fsMaskTextureSize;
in vec2 fsTexture;
in vec2 fsTextureNormalized;
in float fsABSelect;
in vec2 fsNormPos;
out vec4 outColor;

const vec2 directionTable[9] = vec2[] (
                                       vec2( 1, -1),
                                       vec2( 0, -1),
                                       vec2(-1, -1),
                                       vec2( 1,  0),
                                       vec2( 0,  0),
                                       vec2(-1,  0),
                                       vec2( 1,  1),
                                       vec2( 0,  1),
                                       vec2(-1,  1)
                                       );

const vec2 center = vec2(0.5, 0.5);

void main()
{
    vec2 dir = normalize(directionTable[direction] * fsMaskTextureSize);
    dir.y *= verticalDirectionFlip;
    float diagonalScale = abs(dir.x) + abs(dir.y);
    if (diagonalScale > 0)
        dir /= diagonalScale;
    float prog = dot(dir, fsNormPos) - dot(dir, center) + (1 - transitionProgress) * 1.2 - 0.1;
    float alpha = smoothstep(0.4, 0.6, prog);
    alpha = mix(alpha, 1 - alpha, fsABSelect);
    alpha *= baseAlpha;

#ifdef USE_MASK
    alpha *= texture(maskTex, fsMaskTexture).a;
#endif

    outColor = getColor(inputTex, fsTexture);
    multiplyOpacity(outColor, alpha);
}
