#version 330


layout (location=0) in vec3 vsPosition;
layout (location=1) in vec2 vsTexture;
layout (location=2) in vec2 vsTextureMask;
layout (location=3) in vec2 vsTexture2;

uniform sampler2DRect maskTex;
out vec2 fsMaskTexture;

uniform sampler2DRect inputTex;
uniform mat4 worldViewProj;
uniform int transitionState;
uniform float transitionProgressLinear=1.0;
uniform sampler2DRect inputTex1;
uniform int direction;
uniform vec2 windowSize;

out vec2 fsTexture;
out vec2 fsTexture2;
out float fsMix;
out vec2 fsDirection;
out vec2 fsFragScale;

const vec2 fsDirectionTable[9] = vec2[] (
                                         vec2( 1, -1),
                                         vec2( 0, -1),
                                         vec2(-1, -1),
                                         vec2( 1,  0),
                                         vec2( 0,  0),
                                         vec2(-1,  0),
                                         vec2( 1,  1),
                                         vec2( 0,  1),
                                         vec2(-1,  1)
                                         );

void main()
{
    gl_Position=vec4(vsPosition.x,vsPosition.y,vsPosition.z,1.0)*worldViewProj;

    vec2 fsVertex=vsPosition.xy;

    ivec2 texSize=textureSize(inputTex);
    fsTexture = vsTexture*vec2(texSize);

    fsMix=transitionProgressLinear;

    fsFragScale=vec2(1.0,1.0)/windowSize;

    vec2 maskTextureSize = vec2(textureSize(maskTex));
    fsDirection = normalize(fsDirectionTable[direction] * maskTextureSize);

    texSize=textureSize(inputTex1);
    fsTexture2 = vsTexture2*vec2(texSize);
    fsMaskTexture = vsTextureMask * maskTextureSize;
}
