#version 330


layout (location=0) in vec3 vsPosition;
layout (location=1) in vec2 vsTexture;
layout (location=2) in vec2 vsTextureMask;

uniform sampler2DRect inputTex;
uniform mat4 worldViewProj;
uniform sampler2DRect maskTex;
out vec2 fsMaskTexture;
out vec2 fsTexture;
out vec2 fsVertex;

void main()
{
    gl_Position=vec4(vsPosition.x,vsPosition.y,vsPosition.z,1.0)*worldViewProj;

    fsVertex=gl_Position.xy;
    
    ivec2 texSize=textureSize(inputTex);
    fsTexture = vsTexture*vec2(texSize);
    texSize=textureSize(maskTex);
    fsMaskTexture=vsTextureMask*vec2(texSize);
}
