#include "metalShaderTypes.h"
#include "alpha.h"

typedef struct
{
    float fadeLeft;
    float fadeRight;
    float fadeTop;
    float fadeBottom;
} fxVars;



vertex fxVertexOut vertexFunc(uint vertexID [[ vertex_id ]],const device txShaderVers* in[[ buffer(0) ]],constant txShaderUniforms& uniforms[[ buffer(3) ]])
{
    fxVertexOut out;

    out.position=in[vertexID].pos*uniforms.worldViewProj;
    out.position.y*=-1.;
    out.tex1=in[vertexID].tex1;
    out.texMask=in[vertexID].texMask;
    out.mixValue=(out.position.xy+float2(1.0))*.5;
    return out;
}

fragment float4 fragmentFunc(fxVertexOut input [[stage_in]]
                             ,texture2d<half> inputTex0 [[ texture(0) ]]
                             ,texture2d<half> inputTex1 [[ texture(1) ]]
                             ,texture2d<half> inputTexMask [[ texture(2) ]]
                             ,constant txShaderUniforms& uniforms[[ buffer(2) ]]
                             ,constant fxVars& vars[[ buffer(1)]])
{
    float4 outColor=float4(inputTex0.sample(linearSampler,input.tex1));
    float2 t=input.mixValue;
    float blend = smoothstep(0.0, vars.fadeLeft, t.x) * (1 - smoothstep(vars.fadeRight, 1.0, t.x)) * smoothstep(0.0, vars.fadeTop, t.y) * (1 - smoothstep(vars.fadeBottom, 1.0, t.y));
#ifdef USE_MASK
    blend *= float(inputTexMask.sample(linearSampler, input.texMask).a);
#endif
    multiplyOpacity(outColor, blend);
    return outColor;
}
