
#include "metalShaderTypes.h"
#include "alpha.h"

typedef struct
{
    float squareSize;
} fxVars;

float rand(vec2 co)
{
    float a = 12.9898;
    float b = 78.233;
    float c = 43758.5453;
    float dt= dot(co.xy ,vec2(a,b));
    float sn= mod(dt,3.14);
    return fract(sin(sn) * c);
}

vertex vertexOut vertexFunc(uint vertexID [[ vertex_id ]],const device txShaderVers* in[[ buffer(0) ]],constant txShaderUniforms& uniforms[[ buffer(3) ]],constant fxVars& vars[[ buffer(2)]])
{
    vertexOut out;

    out.position=in[vertexID].pos*uniforms.worldViewProj;

    out.tex1=in[vertexID].tex1;
    out.tex2=in[vertexID].tex2;
    out.texMask=in[vertexID].texMask;
    out.normPos=in[vertexID].pos.xy*vec2(.5,.5f)+vec2(.5,.5);
    return out;
}

constant float smoothness=1.0;

fragment float4 fragmentFunc(vertexOut input [[stage_in]]
                             ,texture2d<half> inputTex0 [[ texture(0) ]]
                             ,texture2d<half> inputTex1 [[ texture(1) ]]
                             ,texture2d<half> inputTexMask [[ texture(2) ]]
                             ,constant txShaderUniforms& u[[ buffer(2) ]]
                             ,constant subFXVars& subVars[[buffer(3)]]
                             ,constant fxVars& vars[[ buffer(1)]])
{
    vec2 p = input.normPos;
    float r = rand(floor(vec2((11.0-vars.squareSize)*3.5) * p));
    float m = smoothstep(0.0, -smoothness, r - (u.transitionProgressLinear * (1.0 + smoothness)));
    vec4 texColor=getColor(inputTex0,input.tex1);
    vec4 texelA=mix(vec4(0,0,0,0),texColor,u.mix);
    vec4 texelB=mix(texColor,vec4(0,0,0,0),u.mix);
    float4 outColor;
    mixColor(outColor, texelB, texelA, m);

    float alpha = u.baseAlpha;
#ifdef USE_MASK
    alpha *= float(inputTexMask.sample(linearSampler, input.texMask).a);
#endif
    multiplyOpacity(outColor, alpha);

    return outColor;
}
