#version 330

uniform sampler2DRect inputTex;
uniform sampler2DRect maskTex;

uniform float alpha=1.0;

in vec2 fsTexture;
in vec2 fsMask;

out vec4 outColor;

void main()
{
    outColor = texture(inputTex, fsTexture);
    vec4 maskColor = texture(maskTex, fsMask);
    outColor *= maskColor.a;  // Currently this shader is only used in ProPresenter with premultiplied alpha.

//    // useful for debuging mask positioning, mask corners are colored:
//    // bottom left blue, top left green, top right yellow, bottom right red
//    // texture outside mask is still visible but 0.5 brightness
//    outColor = texture(inputTex, fsTexture);
//    vec4 maskColor = texture(maskTex, fsMask);
//    vec2 maskSize = textureSize(maskTex);
//    float red = fsMask.x / maskSize.x;
//    float green = fsMask.y / maskSize.y;
//    float blue = 0.5 * (1.0 - red + 1.0 - green);
//    outColor *= (1.0 - maskColor.a) * 0.5 + vec4(red, green, blue, 1.0) * maskColor.a;
}


