#version 330

layout (location=0) in vec3 vsPosition;
layout (location=1) in vec2 vsTexture;
layout (location=2) in vec2 vsTextureMask;

uniform sampler2DRect inputTex0;
uniform sampler2DRect inputTex1;
uniform sampler2DRect inputTex2;
uniform sampler2DRect inputTex3;
uniform sampler2DRect inputTexMask;
uniform float vScale;
uniform float hScale;

out vec2 fsTexY;
out vec2 fsTexUV;
out vec2 fsTexA;
out vec2 fsTextureMask;

void main()
{
    gl_Position=vec4(vsPosition.x,vsPosition.y,vsPosition.z,1.0);
    fsTexY = vsTexture;
    fsTexUV = fsTexY*vec2(hScale,vScale);

    vec2 lumaSize=vec2(textureSize(inputTex0));
    vec2 alphaSize=vec2(textureSize(inputTex3));
    vec2 normalized=vsTexture/lumaSize;
    fsTexA=normalized*alphaSize;
    
    fsTextureMask = vsTextureMask;
}
