//

// Fragment shader for Spectrum Analyzer effect
//
// Author: Jeff Brown
//


#version 330


layout( std140 ) uniform vars
{
    vec4 values[32];
};


in vec2 fsVertex;
out vec4 outColor;

void main()
{
    int band=int(fsVertex.x);
    outColor=vec4(0,0,0,1);
    float diff=abs(values[band].y-fsVertex.y);
    if(diff<.01)
        outColor.rgb=vec3(1,1,1)*values[band].y;
    else if(values[band].x>fsVertex.y)
        outColor.rgb=mix(vec3(0,1,0),vec3(1,0,0),fsVertex.y);
    if((band&1)==1)
        outColor.rgb*=1.5;
}
