#version 330

#include "alpha.h"

uniform sampler2DRect inputTex;

in vec2 fsTexture;
#ifndef HQ
in vec2 fsTexSize;
#endif
out vec4 outColor;

void main()
{
#ifdef HQ
    outColor = texture(inputTex, fsTexture);
#else
    vec2 tmpTex;
    tmpTex = fsTexture + vec2(-0.5, 0.5);
    tmpTex = clamp(tmpTex, vec2(0.5, 0.5), fsTexSize);
    outColor = texture(inputTex, tmpTex);

    tmpTex = fsTexture + vec2(0.5, 0.5);
    tmpTex = clamp(tmpTex, vec2(0.5, 0.5), fsTexSize);
    outColor += texture(inputTex, tmpTex);

    tmpTex = fsTexture + vec2(0.5, -0.5);
    tmpTex = clamp(tmpTex, vec2(0.5, 0.5), fsTexSize);
    outColor += texture(inputTex, tmpTex);

    tmpTex = fsTexture + vec2(-0.5, -0.5);
    tmpTex = clamp(tmpTex, vec2(0.5, 0.5), fsTexSize);
    outColor += texture(inputTex, tmpTex);

    outColor *= 0.25;
#endif
    processAlpha(outColor)
}
