//
// Fragment shader for doing "fat" blur
//
// Author: Jeff Brown
//
//


#version 330

#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect maskTex;
uniform float blurAmount;
uniform float blurRadius;
uniform float uPass;
uniform float uBlendValue=1.0;

in vec2 fsTexture;
in vec2 fsMaskTexture;
in vec2 fsTexCoords[15];
in vec2 fsTexNormalized;
out vec4 outColor;

void main()
{
    vec2 center=vec2(.5,.5);
    float dist = length(fsTexNormalized - center);

    vec4 blurColor = vec4(0.0);

    vec4 texel=texture(inputTex,fsTexture);

    blurColor += texture(inputTex, fsTexCoords[ 0]);
    blurColor += texture(inputTex, fsTexCoords[ 1]);
    blurColor += texture(inputTex, fsTexCoords[ 2]);
    blurColor += texture(inputTex, fsTexCoords[ 3]);
    blurColor += texture(inputTex, fsTexCoords[ 4]);
    blurColor += texture(inputTex, fsTexCoords[ 5]);
    blurColor += texture(inputTex, fsTexCoords[ 6]);
    vec4 srcColor = texture(inputTex, fsTexCoords[14]);
    blurColor+=srcColor;
    blurColor += texture(inputTex, fsTexCoords[ 7]);
    blurColor += texture(inputTex, fsTexCoords[ 8]);
    blurColor += texture(inputTex, fsTexCoords[ 9]);
    blurColor += texture(inputTex, fsTexCoords[10]);
    blurColor += texture(inputTex, fsTexCoords[11]);
    blurColor += texture(inputTex, fsTexCoords[12]);
    blurColor += texture(inputTex, fsTexCoords[13]);

    blurColor*=vec4(1.0/15.0,1.0/15.0,1.0/15.0,1.0/15.0);
    float blend=(dist*blurRadius)*4.;
    blend=min(1.0,blend);
    mixColor(outColor, srcColor, blurColor, blend);
    float blendValue=uBlendValue;
#ifdef USE_MASK
    blendValue*=texture(maskTex,fsMaskTexture).a;
#endif
    mixColor(outColor, texel, outColor, blendValue);
}
