#version 330



layout (location=0) in vec3 vsPosition;
layout (location=1) in vec2 vsTexture;
layout (location=2) in vec2 vsTextureMask;
layout (location=3) in vec2 vsTexture2;

uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;
uniform sampler2DRect maskTex;

uniform int transitionState;
uniform float transitionProgress=1.0;
uniform float transitionProgressLinear=1.0;
uniform float transitionAlpha=1.0;
uniform mat4 worldViewProj;

out vec2 fsTexture;
out vec2 fsTexture2;

out vec2 fsTextureNormalized;
out vec2 fsTextureNormalized2;

out vec2 fsMaskTexture;

out vec2 fsTexSize;
out vec2 fsTexSize2;

out float fsAlphaValue;

void main()
{
    gl_Position=vec4(vsPosition,1.0)*worldViewProj;
    
    fsAlphaValue=transitionProgress;
    
    ivec2 texSize=textureSize(inputTex);
    fsTexSize=vec2(texSize);
    fsTexture = vsTexture*fsTexSize;
    fsTextureNormalized=vsTexture;
    
    texSize=textureSize(inputTex1);
    fsTexSize2=vec2(texSize);
    fsTexture2 = vsTexture2*fsTexSize2;
    fsTextureNormalized2=vsTexture2;
    
    fsMaskTexture=vsTextureMask*vec2(textureSize(maskTex));
}
