#version 330

#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;
uniform sampler2DRect maskTex;
uniform float transitionProgress=1.0;
uniform float transitionAlpha=1.0;
uniform float baseAlpha=1.0;

in vec2 fsTexture;
in vec2 fsTexture2;
in vec2 fsTexSize;
in vec2 fsTexSize2;
in vec2 fsTextureNormalized;
in vec2 fsTextureNormalized2;
in vec2 fsMaskTexture;
in float fsAlphaValue;

out vec4 outColor;

void main()
{
    vec4 red,green,blue;
    vec2 texA,texB;
    
    texA=fsTextureNormalized;
    texA.x-=(1.0-fsAlphaValue);
    texA*=fsTexSize;
    
    texB=fsTextureNormalized2;
    texB.x-=fsAlphaValue;
    texB*=fsTexSize2;
    
    red=texture(inputTex,texA)+texture(inputTex1,texB)*(1.0-fsAlphaValue);
    red*=vec4(1.,0.,0.,.33333);
    
    texA=fsTextureNormalized;
    texA.x+=(1.0-fsAlphaValue);
    texA*=fsTexSize;
    
    texB=fsTextureNormalized2;
    texB.x+=fsAlphaValue;
    texB*=fsTexSize2;
    
    green=texture(inputTex,texA)+texture(inputTex1,texB)*(1.0-fsAlphaValue);
    green*=vec4(0.,1.,0.,.33333);
    
    texA=fsTextureNormalized;
    texA.y-=(1.0-fsAlphaValue);
    texA*=fsTexSize;
    
    texB=fsTextureNormalized2;
    texB.y-=fsAlphaValue;
    texB*=fsTexSize2;

    blue=texture(inputTex,texA)+texture(inputTex1,texB)*(1.0-fsAlphaValue);
    blue*=vec4(0.,0.,1.,.33333);
    
    outColor = red+green+blue;
    
#ifdef USE_MASK
    multiplyOpacity(outColor, texture(maskTex, fsMaskTexture).a);
#endif
}


