#version 330

uniform sampler2DRect inputTex;
uniform sampler2DRect maskTex;
uniform float uGlobalTime;
uniform float frequency;
uniform float strobeLength;
uniform float uRandom;
uniform float randomness;

layout (location=0) in vec3 vsPosition;
layout (location=1) in vec2 vsTexture;

out vec2 fsTexture;
out vec2 fsMaskTexture;
out float fsStrobe;

void main()
{
    gl_Position=vec4(vsPosition.x,vsPosition.y,vsPosition.z,1.0);
    fsTexture=vsTexture;
    ivec2 texSize=textureSize(inputTex);
    fsMaskTexture=vsTexture/vec2(texSize);
    texSize=textureSize(maskTex);
    fsMaskTexture*=vec2(texSize);

    float strobe=abs(cos(uGlobalTime*frequency*31.41592653589793));
    float strobeRandom=floor((frequency+1.0)*uRandom);

    strobe=mix(strobe,strobeRandom,randomness);
    if(strobe>(1.0-strobeLength))
        fsStrobe=strobe;
    else
        fsStrobe=0.0;
}
