//

// Fragment shader for Strobe effect
//
// Author: Jeff Brown
//


#version 330

#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect maskTex;
uniform float uTransitionProgress=1.0;
uniform float uBlendValue=1.0;
uniform vec4 strobeColor;
uniform float strobeBlend;


in vec2 fsTexture;
in vec2 fsMaskTexture;
in float fsStrobe;
out vec4 outColor;

void main()
{
    vec4 texel = texture(inputTex, fsTexture);
#ifdef PRE_MULT
    divideAlpha(texel);
#endif
    outColor=vec4(mix(texel.rgb,strobeColor.rgb,fsStrobe*strobeBlend),texel.a);
    float blendValue=uBlendValue;
#ifdef USE_MASK
    blendValue*=texture(maskTex,fsMaskTexture).a;
#endif
    outColor.rgb=mix(texel.rgb,outColor.rgb,blendValue);
#ifdef PRE_MULT
    multiplyAlpha(outColor);
#endif
}
