const vec4 std601X = vec4(  0.299 ,  0.587,  0.114, 0.0  );
const vec4 std601Y = vec4( -0.169 , -0.331,  0.500, 0.0  );
const vec4 std601Z = vec4(  0.500 , -0.419, -0.081, 0.0  );

const vec4 std601R = vec4( 1.596027*0.85882394366802,1.164383*0.85882394366802, 0.000000,0.0  );
const vec4 std601G = vec4(-0.812968*0.85882394366802,1.164383*0.85882394366802,-0.391762*0.85882394366802,0.0  );
const vec4 std601B = vec4( 0.000000,1.164383*0.85882394366802, 2.017232*0.85882394366802,0.0  );


uniform vec2 uvOffset;
uniform vec2 uvScale;
uniform float saturation;

vec4 backgroundEffect(sampler2DRect objectTexture,
                      vec2 objectTextureCoordinates,
                      sampler2DRect blurredBackgroundTexture,
                      sampler2DRect backgroundTexture,
                      vec2 screenPosition)
{
    vec4 objectColor=texture(objectTexture,objectTextureCoordinates);
    vec2 screenCoord=screenPosition*uvScale*vec2(.25,.25)+uvOffset*vec2(.25,.25);

    vec4 blurredBackgroundColor=texture(blurredBackgroundTexture,screenCoord);

    vec4 yuvIn = vec4(dot(std601X, blurredBackgroundColor),
                 dot(std601Y, blurredBackgroundColor),
                 dot(std601Z, blurredBackgroundColor),
                 1.0 );

    vec4 yuvOut;
    
    yuvOut.g = yuvIn.r;
    yuvOut.r = yuvIn.b * (saturation+1.0);
    yuvOut.b = yuvIn.g * (saturation+1.0);
    yuvOut.a = yuvIn.a;
    
    vec4 outColor=vec4(dot(std601R, yuvOut),
                  dot(std601G, yuvOut),
                  dot(std601B, yuvOut),
                  1);

    outColor*=objectColor.a;

    return outColor;
}

