#version 330


layout (location=0) in vec3 vsPosition;
layout (location=1) in vec2 vsTexture;
layout (location=2) in vec2 vsTextureMask;
layout (location=3) in vec2 vsTexture2;

uniform sampler2DRect inputTex;
uniform sampler2DRect maskTex;
uniform mat4 worldViewProj;

uniform int transitionState;
uniform float transitionProgress=1.0;
uniform float transitionProgressLinear=1.0;
uniform float transitionAlpha=1.0;

out vec2 fsTexture;
out vec2 fsTexture2;
out vec2 fsTextureSize;
out vec2 fsTextureSize2;
out vec2 fsTextureNormalized;
out vec2 fsTextureNormalized2;

out vec2 fsMaskTexture;
out float fsMix;

void main()
{
    gl_Position=vec4(vsPosition,1.0)*worldViewProj;
    fsTextureSize=vec2(textureSize(inputTex));
    fsTexture = vsTexture*fsTextureSize;
    fsTextureNormalized=vsTexture;

    fsMaskTexture=vsTextureMask*vec2(textureSize(maskTex));
    fsMix=1.0;
    if(transitionState==2)
        fsMix=0.0;
}
