#version 330

uniform sampler2DRect inputTex;

layout (location=0) in vec3 vsPosition;
layout (location=1) in vec2 vsTexture;

out vec2 fsTexture;
#ifndef HQ
out vec2 fsTexSize;
#endif

void main()
{
    gl_Position = vec4(vsPosition.x, vsPosition.y, vsPosition.z, 1.0);
    fsTexture = vsTexture;
#ifndef HQ
    ivec2 texSize = textureSize(inputTex);
    fsTexSize = vec2(texSize) - vec2(0.5, 0.5);
#endif
}
