#include "metalShaderTypes.h"

typedef struct
{
    float outlineAmount;
    float colorLevel;
} fxVars;

constant float coeffs_fx[9] = {-1.0, 0.0, 1.0,-2.0, 0.0, 2.0,-1.0, 0.0, 1.0};

constant float coeffs_fy[9] = {+1.0f, +2.0f, +1.0f,
    +0.0f, +0.0f, +0.0f,
    -1.0f, -2.0f, -1.0f};

constant vec2 offset[9] = {vec2(-1.0f, +1.0f), vec2(+0.0f, +1.0f), vec2(+1.0f, +1.0f),
    vec2(-1.0f, +0.0f), vec2(+0.0f, +0.0f), vec2(+1.0f, +0.0f),
    vec2(-1.0f, -1.0f), vec2(+0.0f, -1.0f), vec2(+1.0f, -1.0f)};


vertex fxVertexOut vertexFunc(uint vertexID [[ vertex_id ]]
                              ,const device fxShaderVerts* in[[ buffer(0) ]]
                              ,texture2d<half> inputTex0 [[ texture(0) ]]
                              ,texture2d<half> inputTexMask [[ texture(1) ]]
                              ,constant fxGeneralUniforms& u[[ buffer(1) ]]
                              ,constant fxVars& vars[[ buffer(2)]])
{
    fxVertexOut out;

    out.normPos=in[vertexID].pos.xy*vec2(.5,.5f)+vec2(.5,.5);
    out.position=in[vertexID].pos;

    out.tex1=in[vertexID].tex1;
    out.texMask=in[vertexID].texMask;
    out.texSize=float2(inputTex0.get_width(),inputTex0.get_height());
    return out;
}

fragment float4 fragmentFunc(fxVertexOut input [[stage_in]]
                             ,texture2d<half> inputTex [[ texture(0) ]]
                             ,texture2d<half> inputTexMask [[ texture(1) ]]
                             ,constant fxGeneralUniforms& u[[ buffer(0) ]]
                             ,constant fxVars& vars[[ buffer(1)]])
{
    vec2 pos;
    float y = 0.0f, gx = 0.0f, gy = 0.0f;
    vec2 current = fsTexture*input.texSize;;
    for (int i = 0; i < 9; i++)
    {
        pos.x = current.x+offset[i].x;
        pos.y = current.y+offset[i].y;
        vec4 color = getColor(inputTex, pos/input.texSize);
        y=dot(color.rgb, vec3(0.299, 0.587, 0.114));
        gx += (y*coeffs_fx[i]);
        gy += (y*coeffs_fy[i]);
    }
    y = sqrt((gx*gx)+(gy*gy))*vars.outlineAmount;


    vec4 texel=getColor(inputTex,fsTexture);
    float4 outColor = texel*vec4(vars.colorLevel,vars.colorLevel,vars.colorLevel,1.);

    outColor.r+=y;
    outColor.r=min(255.,outColor.r);
    outColor.g+=y;
    outColor.g=min(255.,outColor.g);
    outColor.b+=y;
    outColor.b=min(255.,outColor.b);

    float blendValue=u.blendValue;
#ifdef USE_MASK
    blendValue*=getColor(inputTexMask,input.texMask).a;
#endif
    outColor.rgb=mix(texel.rgb,outColor.rgb,blendValue);
    return outColor;
}
