#include <metal_stdlib>
#pragma clang diagnostic ignored "-Wparentheses-equality"
using namespace metal;
struct effectVerts {
  float3 vsPosition;
  float2 vsTexture;
};
struct vertexOutput {
  float4 gl_Position [[position]];
  float2 fsTexture;
  half2 fsMaskTexture;
  float fsCosHue;
  float fsSinHue;
};
struct AdjustColorUniform {
  float hue;
};
vertex vertexOutput AdjustColorVert(uint vertexID [[ vertex_id ]],device effectVerts* in[[ buffer(0) ]],constant AdjustColorUniform& uniforms[[ buffer(1) ]]
  ,   texture2d<float> inputTex [[texture(0)]], sampler _mtlsmp_inputTex [[sampler(0)]]
  ,   texture2d<float> maskTex [[texture(1)]], sampler _mtlsmp_maskTex [[sampler(1)]])
{
  vertexOutput out;
  float4 tmpvar_1 = 0;
  tmpvar_1.w = 1.0;
  tmpvar_1.xyz = in[vertexID].vsPosition;
  out.gl_Position = tmpvar_1;
  out.fsTexture = in[vertexID].vsTexture;
  short2 tmpvar_2 = 0;
  tmpvar_2 = short2(inputTex.get_width(0), inputTex.get_height(0));
  out.fsMaskTexture = ((half2)(in[vertexID].vsTexture / (float2)(half2(tmpvar_2))));
  short2 tmpvar_3 = 0;
  tmpvar_3 = short2(maskTex.get_width(0), maskTex.get_height(0));
  out.fsMaskTexture = (out.fsMaskTexture * half2(tmpvar_3));
  out.fsCosHue = cos(uniforms.hue);
  out.fsSinHue = sin(uniforms.hue);
  return out;
}


// stats: 7 alu 2 tex 0 flow
// inputs: 2
//  #0: vsPosition (high float) 3x1 [-1] loc 0
//  #1: vsTexture (high float) 2x1 [-1] loc 1
// uniforms: 1 (total size: 4)
//  #0: hue (high float) 1x1 [-1] loc 0
// textures: 2
//  #0: inputTex (high other) 0x0 [-1] loc 0
//  #1: maskTex (high other) 0x0 [-1] loc 1
