//

// Fragment shader for Strobe effect
//
// Author: Jeff Brown
//


#version 330

#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect maskTex;
uniform float uTransitionProgress=1.0;
uniform float uBlendValue=1.0;
uniform float uRandom;
uniform float frequency;
uniform vec4 strobeColor;


in vec2 fsTexture;
in vec2 fsMaskTexture;
in vec2 fsTexture2;
out vec4 outColor;

void main()
{
    float blendValue=uBlendValue;
#ifdef USE_MASK
    blendValue*=texture(maskTex,fsMaskTexture).a;
#endif
    vec4 texel = texture(inputTex,fsTexture2);
    outColor=texture(inputTex,fsTexture);
    mixColor(outColor, texel, outColor, blendValue);
}
