#include "metalShaderTypes.h"
#include "alpha.h"
#include "commonMLDX.h"
#include "outputColorHelper.h"

constant float4 std709X = float4(  0.183,   0.614,  0.062, 0.0  );
constant float4 std709Y = float4( -0.101,  -0.338,  0.439, 0.0  );
constant float4 std709Z = float4(  0.439,  -0.399, -0.040, 0.0  );

struct extractFragOutput2
{
    float4 color0 [[color(0)]];
    float4 color1 [[color(1)]];
};

vertex vertexOut vertexFunc(uint vertexID [[ vertex_id ]],
                                   const device pixCopyVertexFormat* in [[ buffer(0) ]])
{
    vertexOut out;

    out.position = in[vertexID].pos;

    out.tex1 = in[vertexID].tc;
    out.tex2 = in[vertexID].tc;
    out.tex2.x+=1.0;

    return out;
}

fragment float4 fragmentFunc(vertexOut input [[stage_in]],
                             texture2d<half> inputTex0 [[ texture(0) ]])
{
    float2 texSize=float2(inputTex0.get_width(),inputTex0.get_height());
    float2 texCoord=input.tex1;

    float4 texColor0 = toOutput(float4(inputTex0.sample(nearestSampler,texCoord/texSize)));
    texCoord.x+=1.0;
    float4 texColor1 = toOutput(float4(inputTex0.sample(nearestSampler,texCoord/texSize)));
    texCoord.x+=1.0;
    float4 texColor2 = toOutput(float4(inputTex0.sample(nearestSampler,texCoord/texSize)));
    texCoord.x+=1.0;
    float4 texColor3 = toOutput(float4(inputTex0.sample(nearestSampler,texCoord/texSize)));

    float4 yuv0 = float4(dot(std709X, texColor0)+0.0625,
                         dot(std709Y, texColor0)+0.5,
                         dot(std709Z, texColor0)+0.5,
                         1.0 );

    float4 yuv1 = float4(dot(std709X, texColor1)+0.0625,
                         dot(std709Y, texColor1)+0.5,
                         dot(std709Z, texColor1)+0.5,
                         1.0 );

    float4 yuv2 = float4(dot(std709X, texColor2)+0.0625,
                         dot(std709Y, texColor1)+0.5,
                         dot(std709Z, texColor1)+0.5,
                         1.0 );

    float4 yuv3 = float4(dot(std709X, texColor3)+0.0625,
                         dot(std709Y, texColor1)+0.5,
                         dot(std709Z, texColor1)+0.5,
                         1.0 );


    extractFragOutput2 output;
    output.color0=float4(yuv0.g,yuv1.g,yuv2.g,yuv3.g);
    output.color1=float4(yuv0.b,yuv1.b,yuv2.b,yuv3.b);
}

