//
//
//

#version 330

#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect maskTex;

uniform float numOfColors;
uniform float gammaValue;
uniform float uBlendValue=1.0;

in vec2 fsTexture;
in vec2 fsMaskTexture;

out vec4 outColor;

void main(void)
{

    vec4 texel = outColor = texture(inputTex, fsTexture);
#ifdef PRE_MULT
    divideAlpha(texel);
#endif
    outColor = texel;
    outColor.rgb = pow(outColor.rgb, vec3(gammaValue, gammaValue, gammaValue));
    outColor.rgb = outColor.rgb * float(numOfColors);
    outColor.rgb = floor(outColor.rgb);
    outColor.rgb = outColor.rgb /  float(numOfColors);
    outColor.rgb = pow(outColor.rgb, vec3(1.0/gammaValue));
    float blendValue=uBlendValue;
#ifdef USE_MASK
    blendValue*=texture(maskTex,fsMaskTexture).a;
#endif
    outColor.rgb=mix(texel.rgb,outColor.rgb,blendValue);
    outColor.a=texel.a;
#ifdef PRE_MULT
    multiplyAlpha(outColor);
#endif
}

