#version 330

#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;
uniform sampler2DRect maskTex;

uniform float transitionProgress=1.0;
uniform float transitionAlpha=1.0;
uniform int transitionState;
uniform float baseAlpha=1.0;

in vec2 fsTexture;
in vec2 fsTexture2;
in vec2 fsTextureSize;
in vec2 fsTextureSize2;
in vec2 fsMaskTexture;
in vec2 fsTextureNormalized;
in vec2 fsTextureNormalized2;

out vec4 outColor;

void main()
{
    float rad = 1.3 * transitionProgress; // radius from center of the uv texture square
    float swell = 0.5432* transitionProgress; // swell region magnitude
    vec2 CPoint = vec2(0.5, 0.5); // center point
    float dist = length((fsTextureNormalized - CPoint)/vec2(0.70,1));
    vec2 uvOrig = fsTextureNormalized;
    vec2 uvNew = uvOrig;
    float alpha = 0; // blend factor between the 2 textures
    if (dist < rad) // show the new texture - this expands from center outwards
    {
        alpha = 1; //when inside, show the new texture colour
    }
    if (dist > rad && dist < (rad + swell))
    {
        float lambda = smoothstep(rad, rad+swell, dist); // factor in [0,1]
        alpha = 1 - lambda; // modified blend factor
        vec2 vec = (uvOrig - CPoint) ;
        vec2 dir = ((vec)/(length(vec/vec2(0.70,1)))) ;
        uvNew = CPoint + ((1-lambda) * rad + lambda * (rad+swell)) * dir;
    }
    if (dist >= rad + swell)
        alpha = 0; // show the old texture only
    
    uvOrig*=fsTextureSize2;
    uvNew*=fsTextureSize;
    
    vec4 colorA=texture(inputTex1,fsTexture2);
    vec4 colorB=texture(inputTex,uvNew);
    mixColor(outColor, colorA, colorB, alpha);

    alpha = baseAlpha;
#ifdef USE_MASK
    alpha *= texture(maskTex, fsMaskTexture).a;
#endif
    multiplyOpacity(outColor, alpha);
}
