Texture2D inputTex0 : register(t0);
Texture2D inputTex1 : register(t1);
Texture2D inputTex2 : register(t2);
Texture2D inputTex3 : register(t3);
Texture2D maskTex : register(t4);

SamplerState clearBorderSampler : register(s0);
SamplerState nearestSampler : register(s1);

#define textureFetchNearest(a, b) a.Sample(nearestSampler, b)
#define fract(a) frac(a)

#define vec4 float4
#define vec3 float3
#define vec2 float2
#define mix lerp

#ifdef AdobeRGB1998
static const float4 profileToRGB_R = float4(1.398283, -0.398283064, 0.0, 0.0);
static const float4 profileToRGB_G = float4(0.0, 1.0, 0.0, 0.0);
static const float4 profileToRGB_B = float4(0.0, -0.0429382771, 1.04293835, 0.0);
#endif

#ifdef DISPLAY_P3
static const float4 profileToRGB_R = float4(1.2249, -0.2247, 0.0, 0.0);
static const float4 profileToRGB_G = float4(-0.0420, 1.0419, 0.0, 0.0);
static const float4 profileToRGB_B = float4(-0.0197, -0.0786, 1.0979, 0.0);
#endif

#ifdef PRO_PHOTO_RGB
static const float4 profileToRGB_R = float4(2.03407574, -0.72733432, -0.306741565, 0.0);
static const float4 profileToRGB_G = float4(-0.228813201, 1.23173022, -0.00291692792, 0.0);
static const float4 profileToRGB_B = float4(-0.00856976956, -0.153286651, 1.1618564, 0.0);
#endif

#ifdef BT2020
// values obtained from:
// Report ITU-R BT.2407-0 (10/2017) - Colour gamut conversion from Recommendation ITU-R BT.2020 to Recommendation ITU-R
// BT.709
static const float4 profileToRGB_R = float4(1.6605, -0.5876, -0.0728, 0.0);
static const float4 profileToRGB_G = float4(-0.1246, 1.1329, -0.0083, 0.0);
static const float4 profileToRGB_B = float4(-0.0182, -0.1006, 1.1187, 0.0);
#endif

#ifdef FULL_RANGE
// full range values from wikipedia https://en.wikipedia.org/wiki/YCbCr#ITU-R_BT.709_conversion
static const float4 yuv2R = float4(1.402, 1., 0.0, 0.0);
static const float4 yuv2G = float4(-0.714136, 1., -0.344136, 0.0);
static const float4 yuv2B = float4(0.000000, 1., 1.772, 0.0);
static const float4 stdbias = float4(-0.5, 0.0, -0.5, 0.0);
#else
static const float4 yuv2R = float4(1.793, 1.164383, 0.000000, 0.0);
static const float4 yuv2G = float4(-0.534, 1.164383, -0.213, 0.0);
static const float4 yuv2B = float4(0.000000, 1.164383, 2.115, 0.0);
static const float4 stdbias = float4(-0.5, -0.0625, -0.5, 0.0);
#endif

float3 lessThan(float3 a, float3 b)
{
    float3 retVal = float3(0, 0, 0);

    if (a.x < b.x)
        retVal.x = 1.0;
    if (a.y < b.y)
        retVal.y = 1.0;
    if (a.z < b.z)
        retVal.z = 1.0;
    return retVal;
}

float4 toGamma(float4 linearRGB)
{
    float3 cutoff = lessThan(linearRGB.rgb, float3(0.0031308, 0.0031308, 0.0031308));
    float3 higher = float3(1.055, 1.055, 1.055) * pow(linearRGB.rgb, float3(1.0 / 2.4, 1.0 / 2.4, 1.0 / 2.4)) -
                    float3(0.055, 0.055, 0.055);
    float3 lower = linearRGB.rgb * float3(12.92, 12.92, 12.92);

    return float4(lerp(higher, lower, cutoff), linearRGB.a);
}

float4 toLinear(float4 sRGB)
{
    float3 cutoff = lessThan(sRGB.rgb, float3(0.04045, 0.04045, 0.04045));
    float3 higher = pow((sRGB.rgb + float3(0.055, 0.055, 0.055)) / float3(1.055, 1.055, 1.055), float3(2.4, 2.4, 2.4));
    float3 lower = sRGB.rgb / float3(12.92, 12.92, 12.92);

    return float4(lerp(higher, lower, cutoff), sRGB.a);
}

float4 linearizeBT709(float4 bt709)
{
    float3 cutoff = lessThan(bt709.rgb, float3(0.081, 0.081, 0.081));
    float3 higher = pow(bt709.rgb + float3(0.099, 0.099, 0.099), float3(2.2, 2.2, 2.2));
    float3 lower = bt709.rgb / float3(4.5, 4.5, 4.5);

    return float4(mix(higher, lower, cutoff), bt709.a);
}

// data structure : before vertex shader (mesh info)
struct vertexInfo
{
    float3 position : POSITION;
    float2 texCoordY : TEXCOORD0;
};

// data structure : vertex shader to pixel shader
// also called interpolants because values interpolates through the triangle
// from one vertex to another
struct v2p
{
    float4 position : SV_POSITION;
    float2 texCoordY : TEXCOORD0;
    float2 texCoordUV : TEXCOORD1;
};

struct planarUniforms
{
    float4 endColor;
    float hScale;
    float vScale;
    float endOpacity;
    float pad;
};

cbuffer uniformBuffer : register(b0)
{
    planarUniforms uniforms;
}
