#include "inputShaderHelperDX.h"
#include "alpha.h"

v2p vertexShader(vertexInfo input)
{
    v2p output;
    output.position = float4(input.position,1.0);
    output.texCoordY = input.texCoordY;
    output.texCoordUV = input.texCoordY;
    return output;
}




float4 pixelShader(v2p input) : SV_TARGET
{
    float width,height;
    inputTex0.GetDimensions(width,height);
    float2 normalizedTC=input.texCoordY/float2(width,height);

    float4 outColor=textureFetchNearest(inputTex0, normalizedTC).rrrr;

    processAlpha(outColor);

#ifdef USE_MASK
    multiplyOpacity(outColor, textureFetchNearest(maskTex, normalizedTC).a);
#endif
    
#ifdef USE_END_COLOR
    mixColor(outColor, uniforms.endColor, outColor, uniforms.endOpacity);
#endif

    return outColor;
}
