#include "dxEffectIncludes.h"
#include "alpha.h"

typedef struct
{
    float frequency;
    float strobeLength;
    float strobeBlend;
    float randomness;
    float4 strobeColor;
} fxVars;

cbuffer variableBuffer : register(b2)
{
    fxVars vars;
}

fxVertexOut vertexShader(fxShaderVerts input)
{
    fxVertexOut output;
    output.position =float4(input.position,1);
    output.normPos = input.position.xy * vec2(.5,.5f) + vec2(.5,.5);
    output.tex1 = input.tex1;
    output.texMask = input.texMask;
    output.texSize = u.texSize;

    float strobe=abs(cos(u.globalTime*vars.frequency*31.41592653589793));
    float strobeRandom=floor((vars.frequency+1.0)*u.random);

    strobe=mix(strobe,strobeRandom,vars.randomness);
    if(strobe>(1.0-vars.strobeLength))
        output.floatParam0=strobe;
    else
        output.floatParam0=0.0;

    return output;
}


float4 pixelShader(fxVertexOut input) : SV_TARGET
{
    vec4 texel = getColor(inputTex, fsTexture);
#ifdef PRE_MULT
    divideAlpha(texel);
#endif
    float4 outColor=vec4(mix(texel.rgb,vars.strobeColor.rgb,input.floatParam0*vars.strobeBlend),texel.a);
    float blendValue=u.blendValue;
#ifdef USE_MASK
    blendValue *= float(inputTexMask.Sample(linearSampler, input.texMask).a);
#endif
    outColor.rgb=mix(texel.rgb,outColor.rgb,blendValue);
#ifdef PRE_MULT
    multiplyAlpha(outColor);
#endif
    return outColor;
}
